<?php
//FractalizeR's AJAX registration extension for VBulletin 3.7+
//Copyright (c) 2008. All rights reserved

//Variable check
if (! isset($_POST['action'])) {
	access_violation();
}
// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('register');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once ('./global.php');
require_once (DIR . '/includes/functions.php');

$vbulletin->input->clean_gpc('p', 'action', TYPE_STR);

switch($vbulletin->GPC['action']) {
	case "check" :
		$vbulletin->input->clean_gpc('p', 'field', TYPE_STR);
		switch($vbulletin->GPC['field']) {
			case 'username' :
				$vbulletin->input->clean_gpc('p', 'value', TYPE_STR);
				$vbulletin->GPC['value'] = from_utf8($vbulletin->GPC['value']);
				$userdm = & datamanager_init('User', $vbulletin, ERRTYPE_ARRAY);
				if ($userdm->verify_username($vbulletin->GPC['value'])) {
					report_success();
				} else {
					report_error(implode('<BR>', $userdm->errors));
				}
			break;
			
			case 'emails' :
				$vbulletin->input->clean_gpc('p', 'value1', TYPE_STR);
				$vbulletin->input->clean_gpc('p', 'value2', TYPE_STR);
				if ((strlen($vbulletin->GPC['value1']) < 1) or (strlen($vbulletin->GPC['value2']) < 1)) {
					report_error(fetch_error('fieldmissing'));
				}
				if ($vbulletin->GPC['value1'] != $vbulletin->GPC['value2']) {
					report_error(fetch_error('emailmismatch'));
				}				
				$userdm = & datamanager_init('User', $vbulletin, ERRTYPE_ARRAY);
				if ($userdm->verify_useremail($vbulletin->GPC['value1'])) {
					report_success();
				} else {
					report_error(implode('<BR>', $userdm->errors));
				}
			break;
			default :
				access_violation();
				break;
		}
	break;
	case "getphrases" :
		die('{"result":"OK","entered_passwords_do_not_match":"' . addslashes($vbphrase['entered_passwords_do_not_match']) . 
		'","fill_out_both_password_fields":"' . addslashes($vbphrase['fill_out_both_password_fields']) . 
		'","password_quality":"' . addslashes($vbphrase['password_quality']) . 
		'"}');
		break;
	case "suggestpasswords":
		$vbulletin->input->clean_gpc('p', 'maxlength', TYPE_UINT);
		$vbulletin->input->clean_gpc('p', 'maxcapitals', TYPE_UINT);
		if($vbulletin->GPC['maxlength']>30) {
			$vbulletin->GPC['maxlength']=30;
		}
		if($vbulletin->GPC['maxcapitals']>15) {
			$vbulletin->GPC['maxcapitals']=15;
		}

		echo('<div class=smallfont>');
		for($i=0; $i<15; $i++) {
			echo(generatePassword($vbulletin->GPC['maxlength'], $vbulletin->GPC['maxcapitals']).'<BR />');
		}
		echo('</div>');
		break;
	default :
		access_violation();
		break;
}

function report_success($ext = false) {
	die('{"result":"OK","message":""' . (($ext) ? (',' . addslashes($ext)) : ('')) . '}');
}

function report_error($errorText) {
	die('{"result":"Error","message":"' . addslashes($errorText) . '"}');
}

function access_violation() {
	header("HTTP/1.0 403 No access");
	die('HTTP/1.0 403 No access');
}

function generatePassword($length, $maxCapitals) {
	$vowels = array('a', 'e', 'i', 'o', 'u', 'ae', 'ou', 'io', 'ea', 'ia', 'ai');
	
	$consonants = array('b', 'c', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'p', 'r', 's', 't', 'v', 'w', 'x', 'z', 'bs', 'ch', 'cl', 'cr', 'dr', 'fr', 'ft', 'gr', 'kl', 'kr', 'mn', 'pr', 'sh', 'ss', 'st', 'sl', 'tr');
	
	$vowels_count = count($vowels);
	$consonants_count = count($consonants);
	
	$generatedPass = '';
	$passLength = 0;
	$capitalsCount = 0;
	while($passLength < $length) {
		//Selecting current symbol
		$currentSymbol = $consonants[mt_rand(0, $consonants_count - 1)] . $vowels[mt_rand(0, $vowels_count - 1)];
		//Should we start a word?
		if (($capitalsCount < $maxCapitals) and (mt_rand(0, $length) <= ($maxCapitals+2))) {
			$currentSymbol[0] = strtoupper($currentSymbol[0]);
			$capitalsCount ++;
		}
		
		$generatedPass .= $currentSymbol;
		$passLength += strlen($currentSymbol);
	}
	
	return substr($generatedPass, 0, $length);
}

function from_utf8($str) {
	return (convert_urlencoded_unicode(rawurldecode($str)));
}
?>